function [Valt,Halt]=solve_for_V_and_H_closed_form(OMEGA1, OMEGA2, D2);

    D=D2;
    OMEGA=OMEGA2;


    %This bit of cade tells you how to look up elements in Omega
    [k,m] =size(D);
    sumD=sum(D);

    Dalone=zeros(k,1);
    Dminus=zeros(k,k);
    Dplus=zeros(k,k);

    for i=1:m
        for j1=1:k
            for j2=1:k
                if ((D(j1,i)==1)&(D(j2,i)==-1)&(sumD(i)==0)&(j1~=j2))
                    Dminus(j1,j2)=i;
                end
                if ((D(j1,i)==1)&(D(j2,i)==1)&(sumD(i)==2)&(j1~=j2))
                    Dplus(j1,j2)=i;
                end
                if ((D(j1,i)==1)&&(D(j2,i)==1)&&(sumD(i)==1)&&(j1==j2))
                    Dalone(j1)=i;
                end
            end
        end

    end



    V=zeros(2,2);
    H=zeros(2,2);

    Valt=zeros(k,k);
    Halt=zeros(k,k);

    k0=1;

    V1=zeros(k,k,2,2);
    H1=zeros(k,k,2,2);
    for i1=1:k-1;
    for i2=i1+1:k;

        V(1,1)=1;

        j1=Dalone(i1);
        j2=Dalone(i2);

        Ome=OMEGA2([j1;j2],[j1;j2]);
        rho=Ome(1,2)/sqrt(Ome(1,1)*Ome(2,2));
        H(1,1)=1/sqrt(Ome(1,1));
        k1=sqrt(Ome(2,2));

        j2=Dplus(i1,i2);
        Ome=OMEGA2([j1;j2],[j1;j2]);
        k2=Ome(1,2);

        j2=Dminus(i1,i2);
        Ome=OMEGA2([j1;j2],[j1;j2]);
        k3=Ome(1,2);

        A=[(2*k2*H(1,1)) (k2*H(1,1)-rho*k1) ; (-2*k3*H(1,1)) (k3*H(1,1)+rho*k1)];
        b=[(1-k2*H(1,1)^2) ; (1-k3*H(1,1)^2)];

        X=A^(-1)*b;
        H(1,2)=X(1);
        H(2,2)=X(2);
        H(2,1)=H(1,2);

        V(2,2)=(H(2,2)*k1)^2;
        V(1,2)=rho*sqrt(V(1,1)*V(2,2));
        V(2,1)=V(1,2);


        V1(i1,i2,:,:)=V;
        H1(i1,i2,:,:)=H;
    end
    end

    m=1;

    y=zeros(k*(k-1)/2,1);
    x=zeros(k*(k-1)/2,k);
    for i1=1:k-1;
        for i2=i1+1:k;
            y(m)=log(V1(i1,i2,2,2)/V1(i1,i2,1,1));
            x(m,i1)=-1;
            x(m,i2)=1;
            m=m+1;
        end

    end

    x=x(:,2:k);
    b=regress(y,x);

    vv=[1 exp(b)'];
    ss=sqrt(vv);

    for i1=1:k;
        Valt(i1,i1)=vv(i1);
    end;



    for i1=1:k;
        for i2=(i1+1):k

                Valt(i1,i2)=V1(i1,i2,1,2)/sqrt(V1(i1,i2,1,1)*V1(i1,i2,2,2));

                Valt(i1,i2)=Valt(i1,i2)*sqrt(Valt(i1,i1)*Valt(i2,i2));
                Valt(i2,i1)=Valt(i1,i2);

        end
    end    

    Halt(1,1)=H1(1,2,1,1);
    Halt(1,2)=H1(1,2,1,2);
    Halt(2,1)=Halt(1,2);
    Halt(2,2)=H1(1,2,2,2);
    for i2=3:k;
        for i1=1:(k-1)  
           Halt(i1,i2)=H1(i1,i2,1,2)*ss(i1); 
           Halt(i2,i1)=Halt(i1,i2);
        end        
        Halt(i2,i2)=H1(i2-1,i2,2,2)*ss(i2-1);  

    end    


    Valt1=Valt;
    Halt1=Halt;

    Halt=zeros(k,k);
    for i=1:k
        j=Dalone(i);
        Halt(i,i)=sqrt(Valt(i,i)/OMEGA(j,j));
    end

    H0=zeros(k,k);

    for i1=1:k-1;
    for i2=i1+1:k;

        h11=Halt(i1,i1);
        h22=Halt(i2,i2);
        v11=Valt(i1,i1);
        v22=Valt(i2,i2);
        v12=Valt(i1,i2);

        x=zeros(4,1);
        y=zeros(4,1);
        j1=Dalone(i1);
        j2=Dplus(i1,i2);
        Ome=OMEGA2([j1;j2],[j1;j2]);
        k2=Ome(1,2);
        x(1)=2*k2*h11;
        y(1)=v11+v12-k2*h11^2-k2*h11*h22;

        j2=Dminus(i1,i2);
        Ome=OMEGA2([j1;j2],[j1;j2]);
        k3=Ome(1,2);
        x(2)=-2*k3*h11;
        y(2)=v11-v12-k3*h11^2-k3*h11*h22;

        j1=Dalone(i2);
        j2=Dplus(i1,i2);
        Ome=OMEGA2([j1;j2],[j1;j2]);
        k4=Ome(1,2);
        x(3)=2*k4*h22;
        y(3)=v22+v12-k4*h22^2-k4*h11*h22;

        j2=Dminus(i1,i2);
        Ome=OMEGA2([j1;j2],[j1;j2]);
        k5=Ome(1,2);
        x(4)=-2*k5*h22;
        y(4)=-v22+v12-k5*h22^2-k5*h11*h22;

        sx=sign(x);
        h12=(sx'*y)/(sx'*x);

        Halt(i1,i2)=h12;
        Halt(i2,i1)=h12;


    end
    end
end
    
    





 



